# -*- coding: utf-8 -*-

import json
import sys
import uuid
from time import sleep

from webull.core.client import ApiClient
from webull.trade.trade_client import TradeClient

# The current example uses the Webull HK sandbox environment URL and account.
# Please update the configuration according to your actual setup when using it.
optional_api_endpoint = "api.sandbox.webull.hk"
your_app_key = "64fc722617af8b5ebb746f50a910e91f"
your_app_secret = "a268416fc681d438533f9e9316bab576"
region_id = "hk"
api_client = ApiClient(your_app_key, your_app_secret, region_id)
api_client.add_endpoint(region_id, optional_api_endpoint)


if __name__ == '__main__':
    trade_client = TradeClient(api_client)

    # [Note] In the test example, the first account ID returned by the query is used by default for subsequent tests.
    # In a real scenario, you should select and set the desired account_id yourself.
    account_id = None
    res = trade_client.account_v2.get_account_list()
    if res.status_code == 200:
        print('get account list:', res.json())
        account_id = res.json()[0].get('account_id') if res.json() else None
        if not account_id:
            print('Interrupting test process: account_id not found.')
            sys.exit(0)
        else:
            print('get first account_id:', account_id)

    # Query account balance
    res = trade_client.account_v2.get_account_balance(account_id)
    if res.status_code == 200:
        print('get account balance res:', res.json())

    # Query account positions
    res = trade_client.account_v2.get_account_position(account_id)
    if res.status_code == 200:
        print('get account position res:', res.json())

    # us normal equity
    us_normal_equity_client_order_id = uuid.uuid4().hex
    print('us normal equity client order id:', us_normal_equity_client_order_id)
    new_us_normal_equity_orders = [
        {
            "combo_type": "NORMAL",
            "client_order_id": us_normal_equity_client_order_id,
            "symbol": "BULL",
            "instrument_type": "EQUITY",
            "market": "US",
            "order_type": "LIMIT",
            "limit_price": "7",
            "quantity": "1",
            "support_trading_session": "CORE",
            "side": "BUY",
            "time_in_force": "DAY",
            "entrust_type": "QTY"
        }
    ]

    res = trade_client.order_v2.preview_order(account_id, new_us_normal_equity_orders)
    if res.status_code == 200:
        print('preview us normal equity res:', res.json())

    res = trade_client.order_v2.place_order(account_id, new_us_normal_equity_orders)
    if res.status_code == 200:
        print('place us normal equity res:', res.json())
    sleep(3)

    modify_us_normal_orders = [
        {
            "client_order_id": us_normal_equity_client_order_id,
            "quantity": "2",
            "limit_price": "200"
        }
    ]
    res = trade_client.order_v2.replace_order(account_id, modify_us_normal_orders)
    if res.status_code == 200:
        print('replace us normal equity res:', res.json())
    sleep(3)

    res = trade_client.order_v2.get_order_open(account_id=account_id)
    if res.status_code == 200:
        print("order open res:" + json.dumps(res.json(), indent=4))

    res = trade_client.order_v2.cancel_order(account_id, us_normal_equity_client_order_id)
    if res.status_code == 200:
        print('cancel us normal equity res:', res.json())

    res = trade_client.order_v2.get_order_detail(account_id, us_normal_equity_client_order_id)
    if res.status_code == 200:
        print('get us normal equity detail res:', res.json())


    # hk normal equity
    hk_normal_equity_client_order_id = uuid.uuid4().hex
    print('hk normal equity client order id:', hk_normal_equity_client_order_id)
    new_hk_normal_equity_orders = [
        {
            "combo_type": "NORMAL",
            "client_order_id": hk_normal_equity_client_order_id,
            "symbol": "00700",
            "instrument_type": "EQUITY",
            "market": "HK",
            "order_type": "ENHANCED_LIMIT",
            "limit_price": "610",
            "quantity": "100",
            "side": "BUY",
            "time_in_force": "DAY",
            "entrust_type": "QTY"
        }
    ]

    res = trade_client.order_v2.place_order(account_id, new_hk_normal_equity_orders)
    if res.status_code == 200:
        print('place hk normal equity res:', res.json())
    sleep(3)

    res = trade_client.order_v2.cancel_order(account_id, hk_normal_equity_client_order_id)
    if res.status_code == 200:
        print('cancel hk normal equity res:', res.json())


    # cn normal equity
    cn_normal_equity_client_order_id = uuid.uuid4().hex
    print('cn normal equity client order id:', cn_normal_equity_client_order_id)
    new_cn_normal_equity_orders = [
        {
            "combo_type": "NORMAL",
            "client_order_id": cn_normal_equity_client_order_id,
            "symbol": "601318",
            "instrument_type": "EQUITY",
            "market": "CN",
            "order_type": "LIMIT",
            "limit_price": "56",
            "quantity": "100",
            "side": "BUY",
            "time_in_force": "DAY",
            "entrust_type": "QTY"
        }
    ]

    res = trade_client.order_v2.place_order(account_id, new_cn_normal_equity_orders)
    if res.status_code == 200:
        print('place cn normal equity res:', res.json())
    sleep(3)

    res = trade_client.order_v2.cancel_order(account_id, cn_normal_equity_client_order_id)
    if res.status_code == 200:
        print('cancel cn normal equity res:', res.json())



    # us normal option
    new_us_normal_option_client_order_id = uuid.uuid4().hex
    new_us_normal_option_orders = [
        {
            "client_order_id": new_us_normal_option_client_order_id,
            "combo_type": "NORMAL",
            "order_type": "LIMIT",
            "quantity": "1",
            "limit_price": "1.5",
            "option_strategy": "SINGLE",
            "side": "BUY",
            "time_in_force": "DAY",
            "entrust_type": "QTY",
            "legs": [
                {
                    "side": "BUY",
                    "quantity": "1",
                    "symbol": "BULL",
                    "strike_price": "15",
                    "option_expire_date": "2026-03-20",
                    "instrument_type": "OPTION",
                    "option_type": "CALL",
                    "market": "US"
                }
            ]
        }
    ]

    # preview
    res = trade_client.order_v2.preview_option(account_id, new_us_normal_option_orders)
    if res.status_code == 200:
        print("preview us normal option res:" + json.dumps(res.json(), indent=4))

    # place
    res = trade_client.order_v2.place_option(account_id, new_us_normal_option_orders)
    if res.status_code == 200:
        print("place us normal option res:" + json.dumps(res.json(), indent=4))
    sleep(3)

    # cancel
    res = trade_client.order_v2.cancel_option(account_id, new_us_normal_option_client_order_id)
    if res.status_code == 200:
        print("cancel us normal option res:" + json.dumps(res.json(), indent=4))
    sleep(3)